/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.block.Oxidizable;
import com.faboslav.friendsandfoes.init.ModBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    private static final Supplier<BiMap<Block, Block>> WAXED_TO_UNWAXED_BLOCKS = Suppliers.memoize(() -> ImmutableBiMap.builder().put(ModBlocks.WAXED_COPPER_BUTTON.get(), ModBlocks.COPPER_BUTTON.get()).put(ModBlocks.WAXED_EXPOSED_COPPER_BUTTON.get(), ModBlocks.EXPOSED_COPPER_BUTTON.get()).put(ModBlocks.WAXED_WEATHERED_COPPER_BUTTON.get(), ModBlocks.WEATHERED_COPPER_BUTTON.get()).put(ModBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get(), ModBlocks.OXIDIZED_COPPER_BUTTON.get()).build());

    @ModifyVariable(method={"useOnBlock"}, ordinal=1, at=@At(value="STORE"))
    private Optional<BlockState> modifyOxidizedBlock(Optional<BlockState> originalBlockState, UseOnContext context) {
        if (originalBlockState.isPresent()) {
            return originalBlockState;
        }
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = world.m_8055_(blockPos);
        return Oxidizable.getDecreasedOxidationState(blockState);
    }

    @ModifyVariable(method={"useOnBlock"}, ordinal=2, at=@At(value="STORE"))
    private Optional<BlockState> modifyWaxedBlock(Optional<BlockState> originalBlockState, UseOnContext context) {
        if (originalBlockState.isPresent()) {
            return originalBlockState;
        }
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = world.m_8055_(blockPos);
        return Optional.ofNullable((Block)WAXED_TO_UNWAXED_BLOCKS.get().get((Object)blockState.m_60734_())).map(block -> block.m_152465_(blockState));
    }
}

